$(document).ready(function() {

    /* selector for input */
    var ipv4_address = $('#ipv4');
    /*
    create an input mask
    for IP addresses we will use an alias defined
    in the core functions of the plugin, to build a mask
    */
    ipv4_address.inputmask({
        alias: "ip",
        "placeholder": "_"
    });

    /**
     * Function to validate IPv4 addresses
     * @param inputID - id of the input field
     */
    function validateIPAddress(inputID) {
        /* trigger the jquery focusout event */
        $(inputID).on("focusout", function() {
            /*
            save the value of $(this) in the $this variable
            rather than writing $(this) everywhere
            */
            var $this = $(this);
            /* save the entered string from input */
            var entered_ip = $this.val();
            /* check to see if that something was introduced into the field */
            if (entered_ip) {
                /*
                split the resulted string by "." character
                through the jquery split method and
                save the splited values into an array
                */
                var ip_fields_array = entered_ip.split(".");
                /*
                save the formatted ip
                the replace() method searches a string for a specified value,
                or a regular expression, and returns a new string where
                the specified values are replaced.
                (in this case we perform a global replacement)
                */
                var formatted_ip = entered_ip.replace(/_/g, "");
                /* make a html block for incorrect ip address error */
                var ip_error = document.createElement("span");
                ip_error.setAttribute("id", "ip_error");
                var error_message = document.createTextNode(formatted_ip + " is an incorrect IPv4 address");
                ip_error.appendChild(error_message);
                /* make a html block for correct ip address */
                var ip_correct = document.createElement("span");
                ip_correct.setAttribute("id", "ip_success");
                var success_message = document.createTextNode(formatted_ip + " is a correct IPv4 address");
                ip_correct.appendChild(success_message);
                /* store the length of the array */
                var array_length = ip_fields_array.length;
                /*regular expression that starts with 0 and continue with any digit */
                var regex = /^0([0-9])+/;
                /* make an iteration through every item from array */
                for (var i = 0; i < array_length; i++) {
                    var ip_field = ip_fields_array[i];
                    /*
                    remove the "_" char and then test the regex created
                    true -> if we encounter a string that starts with 0
                    and continue with any character (other than white space)
                    false -> otherwise
                    */
                    var regex_result = regex.test(ip_field.replace(/_/g, ""));
                    /*
                    show the error message if one ip field is not entered ("___")
                    and if the regex created is true
                    */
                    if (ip_field == "___" || regex_result == true) {
                        /* remove other messages */
                        $this
                            .siblings("#ip_success")
                            .remove();
                        if ($this.siblings("#ip_error").length == 0) {
                            /* append the html block with proper error */
                            $this
                                .parent()
                                .append(ip_error);
                            $this
                                .removeClass("has-success")
                                .addClass("has-error");
                        }
                        /* stop */
                        return;
                    } else {
                        if ($this.siblings("#ip_success").length == 0) {
                            /* append the html block with success message */
                            $this
                                .parent()
                                .append(ip_correct);
                            $this
                                .removeClass("has-error")
                                .addClass("has-success");
                        }
                    }
                }
            }
        });
        /* trigger the jquery focus event */
        $(inputID).on("focus", function() {
            /* remove all messages */
            $(this)
                .siblings('#ip_success, #ip_error')
                .remove();
        });
    }

    /* call the function */
    validateIPAddress("#ipv4");
});